module.exports = {
  guid() {
    function s4() {
      return Math.floor((1 + Math.random()) * 0x10000).toString(16).substring(1);
    }
    return s4() + s4() + s4();
  },
  allowedTag(tagName) {
    if (tagName.toLowerCase() === 'div' ||
      tagName.toLowerCase() === 'a' ||
      tagName.toLowerCase() === 'span' ||
      tagName.toLowerCase() === 'button' ||
      tagName.toLowerCase() === 'input' ||
      tagName.toLowerCase() === 'img' ||
      tagName.toLowerCase() === 'svg') {
      return true;
    } else {
      return false;
    }
  },
  getComponentProp(props, name) {
    let resp = '';
    Object.keys(props).forEach((index) => {
      if (props[index].name === name) {
        resp = props[index];
      }
    });
    return resp;
  },
  parsePxToNumber(value) {
    // console.log('--------------- PARSE PX TO NUMBER ---------------', value);
    const resp = {};
    if (value.search('px') > -1) {
      resp.value = parseInt(value.split('px')[0]);
      resp.type = 'px';
      return resp;
    } else if (value.search('%') > -1) {
      resp.value = parseInt(value.split('%')[0]);
      resp.type = '%';
      return resp;
    } else if (value.search('flex') > -1) {
      resp.value = parseInt(value.split('-')[1]);
      resp.type = 'flex';
      return resp;
    }
    if (value === 'auto' || value === 'fit-content' || value === 'inherit' || value === 'initial' || value === 'max-content' || value === 'min-content' || value === 'unset' || value === '-webkit-fill-available') {
      resp.value = -1;
      resp.type = value;
      return resp;
    }
    resp.value = parseInt(value);
    resp.type = 'none';
    return resp;
  },
  // isBox(tagName) {
  //   if (tagName.toLowerCase() === 'div' ||
  //   tagName.toLowerCase() === 'p' ||
  //   tagName.toLowerCase() === 'span' ||
  //   tagName.toLowerCase() === 'input' ||
  //   tagName.toLowerCase() === 'input' ||
  //   tagName.toLowerCase() === 'svg') {

  //   }
  // },
  getNodeType(tagName) {
    // TODO implementar
    return 'Box';
  },
  parseColor(color) {
    if (color.toLowerCase().search('rgba') > -1) {
      return color;
    } else if (color.toLowerCase().search('rgb') > -1) {
      return `rgba(${color.split(',')[0].split('(')[1]}, ${color.split(',')[1]}, ${color.split(',')[2].split(')')[0]}, 1.0)`;
    } else {
      return color;
    }
  },
  generateContainerElement(target) {
    var containerElement = JSON.parse(JSON.stringify(target));
    containerElement.name = "container";
    containerElement.instanceName = "container";
    containerElement.children = [];
    containerElement.props.xdElementName = "container";
    containerElement.props.marginTop = "0px";
    containerElement.props.marginRight = "0px";
    containerElement.props.marginBottom = "0px";
    containerElement.props.marginLeft = "0px";
    containerElement.props.paddingTop = "0px";
    containerElement.props.paddingRight = "0px";
    containerElement.props.paddingBottom = "0px";
    containerElement.props.paddingLeft = "0px";
    containerElement.props.top = "0px";
    containerElement.props.right = "0px";
    containerElement.props.bottom = "0px";
    containerElement.props.left = "0px";
    containerElement.props.x = 0;
    containerElement.props.y = 0;
    return containerElement;
  },
  parseSelectedElementObject(element, elemPath, parent) {
    var resp;
    if (element) {
      // console.log('--------------- CAP ---------------', element, elemPath);
      // console.log('--------------- CAP ---------------', element.innerHTML);
      // console.log('--------------- CAP ---------------', element.innerText);
      // console.log('--------------- CAP ---------------', element.children.length);
      // console.log('--------------- CAP ---------------', element.children);
      // console.log('--------------- CAP NODES ---------------', element.childNodes);
      // console.log('--------------- CAP ---------------', element.tagName, element.innerHTML);
      // console.log('--------------- CAP ---------------', style.backgroundColor);

      if (element.nodeName !== '#text') {
        // console.log('--------------- BOX ---------------', element);
        resp = Object.assign({}, this.parseBoxChildren(element, parent));
        if (elemPath !== '') {
          elemPath = `${elemPath}::${resp.instanceName}`;
        } else {
          elemPath = resp.instanceName;
        }
        resp.elemPath = elemPath;
        if (element.childNodes && element.childNodes.length > 0) {
          // var containerElement = Object.assign({}, resp);
          var containerElement = this.generateContainerElement(resp);
          resp.type = "Component";
          resp.children.push(containerElement);
          Object.keys(element.childNodes).forEach((index) => {
            var allowed = true;
            if (element.childNodes[index].nodeName !== "#text") {
              allowed = this.allowedTag(element.childNodes[index].tagName)
            }
            if (allowed && element.childNodes[index].id !== "floatElem") {
              var children = this.parseSelectedElementObject(element.childNodes[index], elemPath, element);
              if (children) {
                resp.children.push(children)
              }
            }
          });
        }
      } else {
        // console.log('--------------- TEXT ---------------', element);
        var nodeValueArray = element.nodeValue.split("");
        var textChar = false;
        Object.keys(nodeValueArray).forEach((index) => {
          var nodeValueArrayMatch = nodeValueArray[index].match(/\n/g);
          if (nodeValueArray[index] !== " ") {
            if (nodeValueArrayMatch && nodeValueArrayMatch.length > 0) {
              textChar = false;
            } else {
              textChar = true;
            }
          }
        });
        if (textChar) {
          resp = Object.assign({}, this.parseTextChildren(element, parent));
        }
      }

    }
    return resp;
  },
  parseBoxChildren(element, parent) {
    var resp;
    var style = getComputedStyle(element);

    resp = {};

    var elementName = element.tagName;
    if (element.id && element.id !== "") {
      elementName = element.id;
    }
    resp.name = elementName;
    resp.instanceName = elementName.substr(0, 50).split(' ').join('').toLowerCase();
    resp.containerElement = false;
    resp._id = this.guid();
    resp.layoutBase = 'anchor';
    resp.layerOrder = 0;
    resp.query = '';
    resp.children = [];
    resp.code = {};
    // if (node.assets) resp.assets = node.assets;
    resp.type = this.getNodeType(element.tagName);
    // resp.subType = utils.getSubTypeFromName(node.name);
    // resp.tag = itemTagName;

    // if (resp.type === 'Text' && node.areaBox) {
    //   resp.type = 'TextArea';
    // }

    // if (resp.type === 'Component') {
    //   item = this.elementToComponent(node, elemPath, layoutBase, element, componentPositionRule);
    // } else {
    // elemPath = `${elemPath}::${resp.instanceName}`;
    // resp.elemPath = elemPath;
    // }

    // resp.tagName = element.tagName;
    // resp.innerHTML = element.innerHTML;

    resp.props = {};
    resp.props.backgroundColor = this.parseColor(style.backgroundColor);
    resp.props.xdElementName = resp.instanceName;
    resp.props.xdWidth = element.getBoundingClientRect().width;
    resp.props.xdHeight = element.getBoundingClientRect().height;
    resp.props.width = `${element.getBoundingClientRect().width}px`;
    resp.props.height = `${element.getBoundingClientRect().height}px`;
    if (parent) {
      resp.props.x = element.getBoundingClientRect().left - parent.getBoundingClientRect().left;
      resp.props.y = element.getBoundingClientRect().top - parent.getBoundingClientRect().top;
      resp.props.top = element.getBoundingClientRect().top - parent.getBoundingClientRect().top;
      resp.props.right = element.getBoundingClientRect().right - parent.getBoundingClientRect().right;
      resp.props.bottom = element.getBoundingClientRect().bottom - parent.getBoundingClientRect().bottom;
      resp.props.left = element.getBoundingClientRect().left - parent.getBoundingClientRect().left;
    } else {
      resp.props.x = element.getBoundingClientRect().left;
      resp.props.y = element.getBoundingClientRect().top;
      resp.props.top = element.getBoundingClientRect().top;
      resp.props.right = element.getBoundingClientRect().right;
      resp.props.bottom = element.getBoundingClientRect().bottom;
      resp.props.left = element.getBoundingClientRect().left;
    }
    // resp.props.xdVisible = style.visible; TODO analisar as possíveis diversas formas que podem produzir esse reultado.
    resp.props.opacity = parseFloat(style.opacity);
    resp.props.marginTop = style.marginTop;
    resp.props.marginRight = style.marginRight;
    resp.props.marginBottom = style.marginBottom;
    resp.props.marginLeft = style.marginLeft;
    resp.props.paddingTop = style.paddingTop;
    resp.props.paddingRight = style.paddingRight;
    resp.props.paddingBottom = style.paddingBottom;
    resp.props.paddingLeft = style.paddingLeft;
    resp.props.borderBottomColor = this.parseColor(style.borderBottomColor);
    resp.props.borderBottomWidth = style.borderBottomWidth;
    resp.props.borderBottomStyle = style.borderBottomStyle;
    resp.props.borderLeftColor = this.parseColor(style.borderLeftColor);
    resp.props.borderLeftWidth = style.borderLeftWidth;
    resp.props.borderLeftStyle = style.borderLeftStyle;
    resp.props.borderTopColor = this.parseColor(style.borderTopColor);
    resp.props.borderTopWidth = style.borderTopWidth;
    resp.props.borderTopStyle = style.borderTopStyle;
    resp.props.borderRightColor = this.parseColor(style.borderRightColor);
    resp.props.borderRightWidth = style.borderRightWidth;
    resp.props.borderRightStyle = style.borderRightStyle;
    resp.props.borderTopLeftRadius = style.borderTopLeftRadius;
    resp.props.borderTopRightRadius = style.borderTopRightRadius;
    resp.props.borderBottomLeftRadius = style.borderBottomLeftRadius;
    resp.props.borderBottomRightRadius = style.borderBottomRightRadius;

    return resp;
  },
  parseTextChildren(element, parent) {
    var resp;
    var style = getComputedStyle(parent);

    resp = {};

    resp.name = element.nodeValue.substr(0, 50);
    resp.instanceName = element.nodeValue.substr(0, 50).split(' ').join('').toLowerCase();
    resp.containerElement = false;
    resp._id = this.guid();
    resp.layoutBase = 'anchor';
    resp.layerOrder = 0;
    resp.query = '';
    resp.children = [];
    resp.code = {};
    // if (node.assets) resp.assets = node.assets;
    resp.type = 'Text';
    // resp.subType = utils.getSubTypeFromName(node.name);
    // resp.tag = itemTagName;

    // if (resp.type === 'Text' && node.areaBox) {
    //   resp.type = 'TextArea';
    // }

    // if (resp.type === 'Component') {
    //   item = this.elementToComponent(node, elemPath, layoutBase, element, componentPositionRule);
    // } else {
    // elemPath = `${elemPath}::${resp.instanceName}`;
    // resp.elemPath = elemPath;
    // }

    // resp.tagName = element.tagName;
    // resp.innerHTML = element.innerHTML;

    resp.props = {};
    resp.props.text = element.nodeValue;
    resp.props.backgroundColor = 'rgba(255, 255, 255, 0)';
    resp.props.xdElementName = resp.instanceName;
    var width = parent.getBoundingClientRect().width - parseFloat(style.paddingRight) - parseFloat(style.paddingLeft);
    var height = parent.getBoundingClientRect().height - parseFloat(style.paddingTop) - parseFloat(style.paddingBottom);
    resp.props.xdWidth = width;
    resp.props.xdHeight = height;
    resp.props.width = `${width}px`;
    resp.props.height = `${height}px`;
    resp.props.x = parent.getBoundingClientRect().left + parseFloat(style.paddingLeft);// TODO precisaria do parent.parent para pegar subtrair um pelo outro e obter o x do parent em relacao ao group
    resp.props.y = parent.getBoundingClientRect().top; + parseFloat(style.paddingTop);// TODO o mesmo de cima
    // resp.props.top = parent.getBoundingClientRect().top;
    // resp.props.right = parent.getBoundingClientRect().right;
    // resp.props.bottom = parent.getBoundingClientRect().bottom;
    // resp.props.left = parent.getBoundingClientRect().left;
    resp.props.xdLocalBoundsX = 0;
    resp.props.xdLocalBoundsY = 0;
    resp.props.textAlign = style.textAlign;

    resp.props.color = style.color;
    resp.props.fontSize = style.fontSize;
    resp.props.fontStyle = style.fontStyle;
    var fontFamily = 'Helvetica Neue';
    var fontFamilyArray;
    if (style.fontFamily && style.fontFamily !== '') {
      fontFamilyArray = style.fontFamily.split(",");
      if (fontFamilyArray && fontFamilyArray.length && fontFamilyArray.length > 0) {
        fontFamily = fontFamilyArray[0].replace(/\"/g, "");
      } else {
        fontFamily = style.fontFamily.replace(/\"/g, "");
      }
    }
    resp.props.fontFamily = fontFamily;
    // resp.props.fontFamily = 'Helvetica Neue';
    // resp.props.charSpacing = element.styleRanges[0].charSpacing;
    // resp.props.underline = element.styleRanges[0].underline;
    // if (element.areaBox) {
    //   resp.props.xdAreaBoxWidth = element.areaBox.width;
    //   resp.props.xdAreaBoxHeight = element.areaBox.height;
    //   resp.props.wrap = 'wrap';
    // } else {
    //   resp.props.wrap = 'pre';
    // }
    // resp.props.xdVisible = style.visible; TODO analisar as possíveis diversas formas que podem produzir esse reultado.
    resp.props.opacity = parseFloat(style.opacity); // TODO implementar forma de pegar essa informação, talvez do parent
    // resp.props.marginTop = style.marginTop;
    // resp.props.marginRight = style.marginRight;
    // resp.props.marginBottom = style.marginBottom;
    // resp.props.marginLeft = style.marginLeft;
    // resp.props.paddingTop = style.paddingTop;
    // resp.props.paddingRight = style.paddingRight;
    // resp.props.paddingBottom = style.paddingBottom;
    // resp.props.paddingLeft = style.paddingLeft;
    // resp.props.borderBottomColor = this.parseColor(style.borderBottomColor);
    // resp.props.borderBottomWidth = style.borderBottomWidth;
    // resp.props.borderBottomStyle = style.borderBottomStyle;
    // resp.props.borderLeftColor = this.parseColor(style.borderLeftColor);
    // resp.props.borderLeftWidth = style.borderLeftWidth;
    // resp.props.borderLeftStyle = style.borderLeftStyle;
    // resp.props.borderTopColor = this.parseColor(style.borderTopColor);
    // resp.props.borderTopWidth = style.borderTopWidth;
    // resp.props.borderTopStyle = style.borderTopStyle;
    // resp.props.borderRightColor = this.parseColor(style.borderRightColor);
    // resp.props.borderRightWidth = style.borderRightWidth;
    // resp.props.borderRightStyle = style.borderRightStyle;
    // resp.props.borderTopLeftRadius = style.borderTopLeftRadius;
    // resp.props.borderTopRightRadius = style.borderTopRightRadius;
    // resp.props.borderBottomLeftRadius = style.borderBottomLeftRadius;
    // resp.props.borderBottomRightRadius = style.borderBottomRightRadius;

    return resp;
  },
  propsMetaData() {
    const resp = {
      contentDirection: {
        type: 'string',
        data: ['horizontal', 'vertical'],
        editable: true,
        bindable: false,
      },
      contentHorizontalAlign: {
        type: 'string',
        data: ['left', 'center', 'right'],
        editable: true,
        bindable: false,
      },
      contentVerticalAlign: {
        type: 'string',
        data: ['top', 'center', 'bottom'],
        editable: true,
        bindable: false,
      },
      backgroundColor: {
        type: 'color',
        editable: false,
        bindable: true,
      },
      backgroundImage: {
        type: 'string',
        editable: false,
        bindable: true,
      },
      xdBackgroundImage: {
        type: 'string',
        editable: false,
        bindable: true,
      },
      width: {
        type: 'size',
        editable: true,
        bindable: true,
      },
      height: {
        type: 'size',
        editable: true,
        bindable: true,
      },
      scroll: {
        type: 'string',
        data: ['hidden', 'horizontal', 'vertical', 'auto'],
        editable: true,
        bindable: true,
      },
      checked: {
        type: 'bool',
        data: ['true', 'false'],
        editable: true,
        bindable: true,
      },
      value: {
        type: 'string',
        editable: true,
        bindable: true,
      },
      name: {
        type: 'string',
        editable: true,
        bindable: true,
      },
      x: {
        type: 'number',
        editable: false,
        bindable: false,
      },
      y: {
        type: 'number',
        editable: false,
        bindable: false,
      },
      position: {
        type: 'string',
        editable: true,
        bindable: false,
      },
      boxSizing: {
        name: '',
        type: 'string',
        editable: true,
        bindable: false,
      },
      fixedWidth: {
        name: '',
        value: true,
        type: 'bool',
        data: ['true', 'false'],
        editable: true,
        bindable: false,
      },
      fixedHeight: {
        type: 'bool',
        data: ['true', 'false'],
        editable: true,
        bindable: false,
      },
      fixedLeft: {
        type: 'bool',
        data: ['true', 'false'],
        editable: true,
        bindable: false,
      },
      fixedTop: {
        type: 'bool',
        data: ['true', 'false'],
        editable: true,
        bindable: false,
      },
      fixedRight: {
        type: 'bool',
        data: ['true', 'false'],
        editable: true,
        bindable: false,
      },
      fixedBottom: {
        type: 'bool',
        data: ['true', 'false'],
        editable: true,
        bindable: false,
      },
      xdWidth: {
        type: 'number',
        editable: false,
        bindable: false,
      },
      xdHeight: {
        type: 'number',
        editable: false,
        bindable: false,
      },
      xdVisible: {
        type: 'bool',
        data: ['true', 'false'],
        editable: false,
        bindable: false,
      },
      xdElementName: {
        type: 'string',
        editable: false,
        bindable: false,
      },
      opacity: {
        type: 'number',
        editable: false,
        bindable: true,
      },
      cursor: {
        type: 'string',
        data: ['default', 'pointer'],
        editable: true,
        bindable: true,
      },
      marginTop: {
        type: 'pixel',
        editable: true,
        bindable: true,
      },
      marginRight: {
        type: 'pixel',
        editable: true,
        bindable: true,
      },
      marginBottom: {
        type: 'pixel',
        editable: true,
        bindable: true,
      },
      marginLeft: {
        type: 'pixel',
        editable: true,
        bindable: true,
      },
      paddingTop: {
        type: 'pixel',
        editable: true,
        bindable: true,
      },
      paddingRight: {
        type: 'pixel',
        editable: true,
        bindable: true,
      },
      paddingBottom: {
        type: 'pixel',
        editable: true,
        bindable: true,
      },
      paddingLeft: {
        type: 'pixel',
        editable: true,
        bindable: true,
      },
      borderBottomColor: {
        type: 'color',
        editable: false,
        bindable: true,
      },
      borderBottomStyle: {
        data: ['none', 'solid', 'dotted', 'dashed', 'double'],
        type: 'string',
        editable: false,
        bindable: true,
      },
      borderBottomWidth: {
        type: 'pixel',
        editable: false,
        bindable: true,
      },
      borderLeftColor: {
        type: 'color',
        editable: false,
        bindable: true,
      },
      borderLeftStyle: {
        type: 'string',
        data: ['none', 'solid', 'dotted', 'dashed', 'double'],
        editable: false,
        bindable: true,
      },
      borderLeftWidth: {
        type: 'pixel',
        editable: false,
        bindable: true,
      },
      borderRightColor: {
        type: 'color',
        editable: false,
        bindable: true,
      },
      borderRightStyle: {
        type: 'string',
        data: ['none', 'solid', 'dotted', 'dashed', 'double'],
        editable: false,
        bindable: true,
      },
      borderRightWidth: {
        type: 'pixel',
        editable: false,
        bindable: true,
      },
      borderTopColor: {
        type: 'color',
        editable: false,
        bindable: true,
      },
      borderTopStyle: {
        type: 'string',
        data: ['none', 'solid', 'dotted', 'dashed', 'double'],
        editable: false,
        bindable: true,
      },
      borderTopWidth: {
        type: 'pixel',
        editable: false,
        bindable: true,
      },
      borderTopLeftRadius: {
        type: 'pixel',
        editable: false,
        bindable: true,
      },
      borderTopRightRadius: {
        type: 'pixel',
        editable: false,
        bindable: true,
      },
      borderBottomLeftRadius: {
        type: 'pixel',
        editable: false,
        bindable: true,
      },
      borderBottomRightRadius: {
        type: 'pixel',
        editable: false,
        bindable: true,
      },
      shadowHorizontalSize: {
        type: 'pixel',
        editable: false,
        bindable: true,
      },
      shadowVerticalSize: {
        type: 'pixel',
        editable: false,
        bindable: true,
      },
      shadowBlur: {
        type: 'pixel',
        editable: false,
        bindable: true,
      },
      shadowSpred: {
        type: 'number',
        editable: true,
        bindable: true,
      },
      shadowColor: {
        type: 'color',
        editable: false,
        bindable: true,
      },
      displayShadow: {
        type: 'bool',
        data: ['true', 'false'],
        editable: false,
        bindable: true,
      },
      xdRadiusX: {
        type: 'number',
        editable: false,
        bindable: false,
      },
      xdRadiusY: {
        type: 'number',
        editable: false,
        bindable: false,
      },
      fill: {
        type: 'color',
        editable: false,
        bindable: true,
      },
      xdLocalBoundsX: {
        type: 'number',
        editable: false,
        bindable: false,
      },
      xdLocalBoundsY: {
        type: 'number',
        editable: false,
        bindable: false,
      },
      pathData: {
        type: 'string',
        editable: false,
        bindable: false,
      },
      stroke: {
        type: 'color',
        editable: false,
        bindable: true,
      },
      strokeStyle: {
        type: 'string',
        editable: false,
        bindable: true,
      },
      strokeWidth: {
        type: 'pixel',
        editable: false,
        bindable: true,
      },
      text: {
        type: 'string',
        editable: false,
        bindable: true,
      },
      textAlign: {
        type: 'string',
        data: ['left', 'center', 'right', 'justify'],
        editable: false,
        bindable: true,
      },
      color: {
        type: 'color',
        editable: false,
        bindable: true,
      },
      fontSize: {
        type: 'pixel',
        editable: false,
        bindable: true,
      },
      fontStyle: {
        type: 'string',
        data: ['Regular', 'Light', 'Medium', 'Bold'],
        editable: false,
        bindable: true,
      },
      fontFamily: {
        type: 'string',
        editable: false,
        bindable: true,
      },
      charSpacing: {
        type: 'number',
        editable: false,
        bindable: true,
      },
      underline: {
        type: 'bool',
        data: ['true', 'false'],
        editable: false,
        bindable: true,
      },
      xdAreaBoxWidth: {
        type: 'size',
        editable: false,
        bindable: true,
      },
      xdAreaBoxHeight: {
        type: 'size',
        editable: false,
        bindable: true,
      },
      wrap: {
        type: 'string',
        data: ['wrap', 'nowrap', 'pre'],
        editable: true,
        bindable: true,
      },
      widthPercent: {
        type: 'string',
        editable: true,
        bindable: false,
      },
      heightPercent: {
        type: 'string',
        editable: true,
        bindable: false,
      },
      left: {
        type: 'pixel',
        editable: true,
        bindable: true,
      },
      right: {
        type: 'pixel',
        editable: true,
        bindable: true,
      },
      top: {
        type: 'pixel',
        editable: true,
        bindable: true,
      },
      bottom: {
        type: 'pixel',
        editable: true,
        bindable: true,
      },
      gridColumnStart: {
        type: 'number',
        editable: false,
        bindable: false,
      },
      gridRowStart: {
        type: 'number',
        editable: false,
        bindable: false,
      },
      gridColumnEnd: {
        type: 'number',
        editable: false,
        bindable: false,
      },
      gridRowEnd: {
        type: 'number',
        editable: false,
        bindable: false,
      },
      containerElementInstanceName: {
        type: 'string',
        editable: false,
        bindable: false,
      },
    };
    return resp;
  },
}