import { LitElement, html } from '@polymer/lit-element';
import '../components/main/main';
import { MainContainerStyle } from './main-container.style';

export class MainContainerElement extends LitElement {
  static get properties() {
    return {
      loadingLeft: { type: String, reflect: true },
      title: { type: String, reflect: true },
      url: { type: String, reflect: true },
    };
  }

  attributeChangedCallback(name, oldval, newval) {
    // console.log('--------------- ATTR ---------------', name, newval);
    super.attributeChangedCallback(name, oldval, newval);
    // this.requestUpdate();
  }

  set loadingLeft(newval) {
    this._loadingLeft = newval;
    this.requestUpdate();
  }
  get loadingLeft() {
    return this._loadingLeft;
  }

  set title(newval) {
    this._title = newval;
    this.requestUpdate();
  }
  get title() {
    return this._title;
  }

  set url(newval) {
    let refresh = false;
    if (newval !== '' && this.url === newval) {
      refresh = true;
    }
    this._url = newval;
    this.requestUpdate();
    if (refresh) {
      const webview = this.shadowRoot.querySelector('webview');
      webview.reload();
    }
    
  }
  get url() {
    return this._url;
  }

  showPreview(preview) {
    console.log('--------------- SHOW CONTENT ---------------', preview);
    const mainStage = this.shadowRoot.querySelector('webview');
    console.log('--------------- info ---------------', mainStage);
    mainStage.addEventListener('dom-ready', () => {
      mainStage.insertCSS(preview.css);
      mainStage.openDevTools();
      mainStage.executeJavaScript(`document.body.innerHTML = ${JSON.stringify(body)};`, (e) => {

      });
    })
    let body = preview.html.split('<body>')[1];
    body = body.split('</body>')[0];
    // console.log('--------------- BODY ---------------', body);
    
  }
  clearPreview() {
    const mainStage = this.shadowRoot.querySelector('webview');
    mainStage.addEventListener('dom-ready', () => {
      mainStage.insertCSS('');
      mainStage.executeJavaScript(`document.body.innerHTML = '';`, (e) => {

      });
    })
  }

  constructor() {
    super();

    this.loadingLeft = "";
    this.title = "";
    this.url = '';

  }

  render() {
    // console.log('--------------- info ---------------', this.title);
    // console.log('--------------- info ---------------', this.loadingLeft);
    // console.log('--------------- preview-url ---------------', this.url);
    return html`
    <style>
      ${MainContainerStyle}
    </style>
    <main-element title="${this.title}" loadingLeft="${this.loadingLeft}">
      <!-- <webview slot="center-panel" src="${this.url}" autosize="on" preload="./preload.js" minwidth="200" minheight="200" nodeintegration></webview> -->
      <webview slot="center-panel" src="${this.url}" autosize="on" preload="./preload.js" minwidth="200" minheight="200" nodeintegration></webview>
      <img id="loading" slot="loading" src="./assets/loading.svg" width="80" height="80">
    </main-element>
    `;
  }

  firstUpdated() {
    const mainElement = this.shadowRoot.querySelector('main-element');

    // this.showPreview();

    // mainElement.addEventListener('project-title-box:click', (e) => {
    //   // console.log('--------------- info ---------------', e.detail);
    //   this.dispatchEvent(new CustomEvent(`project:select`, {
    //     bubbles: true,
    //     detail: {
    //       instanceName: e.detail
    //     }
    //   }));
    // });

  }

  async changeProp() {
    // console.log('--------------- CHANGE PROP ---------------');
    await Promise.all(this.updateComplete, this.getMoreState());
    console.log('Update complete. Other state completed.');
  }
}
customElements.define('main-container-element', MainContainerElement);
