const { ipcRenderer } = require('electron');
const getQuerySelector = require("get-query-selector");
const utils = require("./utils");

// global.pingHost = (func) => {
//     console.log('--------------- PRELOAD ---------------');
//   // ipcRenderer.sendToHost('ping-merda', 'foi');
//   ipcRenderer.send('ping-merda', 'fooi');
// }

global.captureElement = (selector) => {
  // console.log('--------------- VISIBLE ---------------', selector);
  var target = document.querySelector(selector);
  var resp = utils.parseSelectedElementObject(target, '');
  resp = Object.assign({}, resp, {
    assets: [],
    library: "",
    customProps: {},
    binds: {},
    edits: {
      universal: {},
      devices: {},
    },
    columns: [],
    rows: [],
    export: {},
    setup: {
      pathExportAsSvg: true
    },
    propsMetaData: utils.propsMetaData()
  });
  // console.log('--------------- PARSE ---------------', utils.parseSelectedElementObject(target, '', getComputedStyle(target)));
  return resp;
}

global.highlightElement = (selector) => {
  // console.log('--------------- VISIBLE ---------------', selector);
  var target = document.querySelector(selector);
  if (target) {
    targetSelected = target;
    // console.log('--------------- BORDER ---------------', getComputedStyle(target).border);
    target.scrollIntoViewIfNeeded(true);
    float = document.createElement('DIV');
    float.style.cssText = `
    position: fixed;
    left: ${target.getBoundingClientRect().left}px;
    top: ${target.getBoundingClientRect().top}px;
    width: ${target.getBoundingClientRect().width}px;
    height: ${target.getBoundingClientRect().height}px;
    // background-color: ${getComputedStyle(target.parentElement).backgroundColor};
    background-color: rgba(21,146,230,0.1);
    z-index: 1000;
    // border: 2px solid #1592E6;
    outline: 2px solid #1592E6;
    // border: 1px solid #31AFE6;
    box-shadow: 0px 0px 5px #006296;
    `;
    float.id = 'floatElem';
    document.body.appendChild(float);
  }
}
global.removeHighlight = () => {
  float = document.getElementById('floatElem');
  if (float) document.body.removeChild(float);
}
global.getDoc = () => {
  // console.log('--------------- AQUI ---------------', document.getElementsByTagName('body')[0]);
  // console.log('--------------- AQUI ---------------', document.getElementsByTagName('body')[0].childNodes);
  // console.log('--------------- AQUI ---------------', JSON.stringify(document.getElementsByTagName('body')[0]));
  // console.log('--------------- AQUI ---------------', document.getElementsByTagName('body')[0].toString());
  // return JSON.stringify(document.getElementsByTagName('body')[0]);
  // return document.getElementsByTagName('body')[0].innerHTML;
  // var html = {};
  // html.body = parseHtmlToObject(document.getElementsByTagName('body')[0].children);
  // return html;
  var html = parseHtmlToObject(document.getElementsByTagName('body')[0]);
  // console.log('--------------- HTML ---------------', document.getElementsByTagName('body')[0].childNodes, html);
  // console.log('--------------- info ---------------', document.querySelector("body>:nth-child(1)"));
  // console.log('--------------- info ---------------', document.querySelector("body>:nth-child(1)>:nth-child(3)>:nth-child(1)>:nth-child(2)"));
  return html;
}

parseHtmlToObject = (elem, tab) => {
  if (!tab) {
    tab = 10;
  }
  var tagName;
  if (elem.tagName) {
    tagName = elem.tagName;
  } else {
    tagName = "TEXT";
  }
  // body > div.application-main > main > div:nth-child(6) > div > p.lead-mktg.text-gray.text-center.col-md-8.mx-auto.mb-4
  // /html/body/div[4]/main/div[6]/div/p[2]
  var classList = [];
  var classNames = "";
  if (elem.classList && elem.classList.length > 0) {
    classList = elem.classList;
    var classListArray = [];
    Object.keys(elem.classList).forEach((index) => {
      classListArray.push(elem.classList[index]);
    });
    classNames = classListArray.join(', ');
  }
  var html = {
    type: tagName,
    children: [],
    classList: classList,
    classNames: classNames,
    selector: getQuerySelector(elem),
    tab: `${tab}px`
  };
  if (elem.childNodes && elem.childNodes.length > 0) {
    var nTab = tab + 10;
    Object.keys(elem.childNodes).forEach((index) => {
      // console.log('--------------- CN ---------------', index, elem.children[index].tagName);
      if (elem.childNodes[index].tagName && utils.allowedTag(elem.childNodes[index].tagName)) {
        html.children.push(parseHtmlToObject(elem.childNodes[index], nTab));
      }
    });
  }
  return html;
}

cssPath = (el) => {
  if (!(el instanceof Element)) return;
  var path = [];
  while (el.nodeType === Node.ELEMENT_NODE) {
    var selector = el.nodeName.toLowerCase();
    if (el.id) {
      selector += '#' + el.id;
    } else {
      var sib = el, nth = 1;
      while (sib.nodeType === Node.ELEMENT_NODE && (sib = sib.previousSibling) && nth++);
      selector += ":nth-child(" + nth + ")";
    }
    path.unshift(selector);
    el = el.parentNode;
  }
  return path.join(" > ");
}

// TODO implementar funcoes que permitam demonstrar em qual elemento o usuario está selecionando na lista ao lado.
// TODO implementar funcoes que permitam acessar e extrair informacoes (css, style) das DIVs.