// Modules to control application life and create native browser window
const { app, BrowserWindow, Menu, dialog, shell } = require('electron');
const fs = require('fs');
const utils = require('./utils');

// Keep a global reference of the window object, if you don't, the window will
// be closed automatically when the JavaScript object is garbage collected.
let mainWindow

function createWindow() {
  // Create the browser window.
  mainWindow = new BrowserWindow({ width: 1440, height: 900 })

  // and load the index.html of the app.
  // mainWindow.loadFile('./src/components/home/home.html');
  // NOTE to dev
  // mainWindow.loadFile('index.html');
  // NOTE to build
  mainWindow.loadFile('build/default/index.html');

  // Open the DevTools.
  // mainWindow.webContents.openDevTools();

  // Emitted when the window is closed.
  mainWindow.on('closed', function () {
    // Dereference the window object, usually you would store windows
    // in an array if your app supports multi windows, this is the time
    // when you should delete the corresponding element.
    mainWindow = null
  })
}

// This method will be called when Electron has finished
// initialization and is ready to create browser windows.
// Some APIs can only be used after this event occurs.
app.on('ready', createWindow)

// Quit when all windows are closed.
app.on('window-all-closed', function () {
  // On macOS it is common for applications and their menu bar
  // to stay active until the user quits explicitly with Cmd + Q
  if (process.platform !== 'darwin') {
    app.quit()
  }
})

app.on('activate', function () {
  // On macOS it's common to re-create a window in the app when the
  // dock icon is clicked and there are no other windows open.
  if (mainWindow === null) {
    createWindow()
  }
})

const WebSocket = require('ws');

const wss = new WebSocket.Server({ port: 55552 });

wss.on('connection', function connection(ws) {
  ws.on('message', function incoming(message) {
    let command = JSON.parse(message);
    // console.log('--------------- COMMAND ---------------', command);
    if (command.msg === 'connect') {
      // mainWindow.loadFile('index.html');
    // } else if (command.msg === 'home') {
    //   mainWindow.loadFile('./src/components/home/home.html');
    } else if (command.msg === 'reload') {
      mainWindow.reload();
    } else if (command.msg === 'preview') {
      mainWindow.focus();
      // mainWindow.loadFile('index.html');
      mainWindow.webContents.send('preview-url', command.data.url, command.data.title);
    }
  });

  ws.send('something');
});


// In this file you can include the rest of your app's specific main process
// code. You can also put them in separate files and require them here.
const ipc = require('electron').ipcMain;
// const ipcRenderer = require('electron').ipcRenderer;
// const dialog = require('electron').dialog
// let settings;

// ipc.on('list-containers', function (event) {
//   event.sender.send('list-containers-response', getContainers());
// })