import { LitElement, html } from '@polymer/lit-element';
import './containers/main-container';
import './components/home/home';
import { AppStyle } from './app.style';

const ipc = require('electron').ipcRenderer;

export class AppElement extends LitElement {
  static get properties() {
    return {
      loading: { type: Boolean, reflect: true },
      warning: { type: String, reflect: true },
      title: { type: String, reflect: true }, 
      url: { type: String, reflect: true },
    };
  }

  attributeChangedCallback(name, oldval, newval) {
    if (name === 'components' || name === 'states') {
      oldval = null;
    }
    // console.log('--------------- ATTR ---------------', name, oldval, newval);
    super.attributeChangedCallback(name, oldval, newval);
    // this.requestUpdate();
  }

  set loading(newval) {
    this._loading = newval;
    const mainContainerElem = this.shadowRoot.querySelector('main-container-element');
    if (this._loading === true && this.url !== '') {
      mainContainerElem.setAttribute('loadingLeft', '0.00px');
    } else if (this.url !== '') {
      mainContainerElem.setAttribute('loadingLeft', '8000.00px');
    }
    this.requestUpdate();
  }
  get loading() {
    return this._loading;
  }

  set warning(newval) {
    this._warning = newval;
    console.log('--------------- WARNINH ---------------', newval);
    // const mainContainerElem = this.shadowRoot.querySelector('main-container-element');
    // if (this._warning === 'show') {
    //   mainContainerElem.setAttribute('warningLeft', '0.00px');
    // } else {
    //   mainContainerElem.setAttribute('warningLeft', '8000.00px');
    // }
    this.requestUpdate();
  }
  get warning() {
    return this._warning;
  }

  set title(newval) {
    this._title = newval;
    this.requestUpdate();
  }
  get title() {
    return this._title;
  }

  set url(newval) {
    this._url = newval;
    this.requestUpdate();
  }
  get url() {
    return this._url;
  }

  constructor() {
    super();

    this.title = "Waiting design to preview...";
    this.url = '';

  }

  render() {

    let content = html`<home-element />`;
    if (this.url && this.url !== '') {
      content = html`<main-container-element loadingLeft="8000.00px" title="${this.title}" url="${this.url}" />`;
    }
    return html`
    <style>
      ${AppStyle}
    </style>
    ${content}
    `;
  }

  firstUpdated() {
    const mainContainerElem = this.shadowRoot.querySelector('main-container-element');

    this.loading = false;

    // mainContainerElem.addEventListener('project:select', (e) => {
    //   // console.log('--------------- info ---------------', e.detail);
    //   this.dispatchEvent(new CustomEvent(`project:select`, {
    //     bubbles: true,
    //     detail: e.detail
    //   }));
    // });
  }

  async changeProp() {
    // console.log('--------------- CHANGE PROP ---------------');
    await Promise.all(this.updateComplete, this.getMoreState());
    console.log('Update complete. Other state completed.');
  }

  // async loadLazy() {
  //   console.log('loadLazy');
  //   if(!this.loadComplete) {
  //     this.loadComplete = true;
  //     return import('./lazy-element.js').then((LazyElement) => {
  //       console.log("LazyElement loaded");
  //     }).catch((reason) => {
  //       console.log("LazyElement failed to load", reason);
  //     });
  //   }
  // }
}
customElements.define('app-element', AppElement);
